////////////////////////////////////////////////////////////////////////////////
//
//               Groundfire
//
////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2004, Tom Russell (tom@groundfire.net)
//
// This file is part of the Groundfire project, distributed under the MIT 
// license. See the file 'COPYING', included with this distribution, for a copy
// of the full MIT licence.
//
////////////////////////////////////////////////////////////////////////////////
//
//   File name : humanplayer.cc
//
//          By : Tom Russell
//
//        Date : 24-Mar-04
//
// Description : Handles local-human (non-AI) players
//
//
//
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Includes
////////////////////////////////////////////////////////////////////////////////
#include "humanplayer.hh"
#include "controls.hh"

////////////////////////////////////////////////////////////////////////////////
// Public Member Functions
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
//
// Function    : cHumanPlayer
//
// Description : Constructor
//
////////////////////////////////////////////////////////////////////////////////
cHumanPlayer::cHumanPlayer
(
    cGame     * game,
    int         number, 
    int         controller,
    cControls * controls
)
        : cPlayer (game, number), _controller (controller), _controls (controls)
{
}

////////////////////////////////////////////////////////////////////////////////
//
// Function    : ~cHumanPlayer
//
// Description : Destructor
//
////////////////////////////////////////////////////////////////////////////////
cHumanPlayer::~cHumanPlayer
(
)
{
}

////////////////////////////////////////////////////////////////////////////////
//
// Function    : getCommand
//
// Description : Get the state of a control for a human player
//
////////////////////////////////////////////////////////////////////////////////
bool
cHumanPlayer::getCommand
(
    command_t   command,
    double    & startTime
)
{
    startTime = 0;

    return (_controls->getCommand (_controller, command));
}
