////////////////////////////////////////////////////////////////////////////////
//
//               Groundfire
//
////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2004, Tom Russell (tom@groundfire.net)
//
// This file is part of the Groundfire project, distributed under the MIT 
// license. See the file 'COPYING', included with this distribution, for a copy
// of the full MIT licence.
//
////////////////////////////////////////////////////////////////////////////////
//
//   File name : common.cc
//
//          By : Tom Russell
//
//        Date : 02-Feb-03
//
// Description : Common functions and constants
//
//
//
////////////////////////////////////////////////////////////////////////////////
#ifndef __COMMON_HH__
#define __COMMON_HH__

#include <math.h>

#define PI 3.141592654
    
////////////////////////////////////////////////////////////////////////////////
//
// Function    : sqr
//
// Description : x^2
//
////////////////////////////////////////////////////////////////////////////////
inline float 
sqr
(
    float x
)
{
    return (x * x);
}

////////////////////////////////////////////////////////////////////////////////
//
// Function    : degCos
//
// Description : Takes an angle in degrees and returns the cosine
//
////////////////////////////////////////////////////////////////////////////////
inline float 
degCos
(
    float angle
)
{
    return (cos ((angle / 180.0f) * PI));
}

////////////////////////////////////////////////////////////////////////////////
//
// Function    : degSin
//
// Description : Takes an angle in degrees and returns the sine
//
////////////////////////////////////////////////////////////////////////////////
inline float 
degSin
(
    float angle
)
{
    return (sin ((angle / 180.0f) * PI));
}


#endif // __COMMON_HH__
