////////////////////////////////////////////////////////////////////////////////
//
//               Groundfire
//
////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2004, Tom Russell (tom@groundfire.net)
//
// This file is part of the Groundfire project, distributed under the MIT 
// license. See the file 'COPYING', included with this distribution, for a copy
// of the full MIT licence.
//
////////////////////////////////////////////////////////////////////////////////
//
//   File name : mirvweapon.hh
//
//          By : Tom Russell
//
//        Date : 04-Apr-04
//
// Description : Handles the mirv weapon of a tank
//
//
//
////////////////////////////////////////////////////////////////////////////////
#ifndef __MIRVWEAPON_HH__
#define __MIRVWEAPON_HH__

////////////////////////////////////////////////////////////////////////////////
// Includes
////////////////////////////////////////////////////////////////////////////////
#include "weapon.hh"

////////////////////////////////////////////////////////////////////////////////
// Exception Classes
////////////////////////////////////////////////////////////////////////////////

class cMirvWeapon : public cWeapon
{
public:
    cMirvWeapon (cGame * game, cTank * ownerTank);
    ~cMirvWeapon ();

    static void readSettings (cReadIniFile const & settings);

    bool fire (bool starting, float time);
    void update (float time);
    bool select (void);
    void drawGraphic (float x);

private:
    // Settings Variables
    static float OPTION_BlastSize;
    static float OPTION_CooldownTime;
    static float OPTION_Damage;
    static int   OPTION_Cost;
};

#endif // __MIRVWEAPON_HH__
