////////////////////////////////////////////////////////////////////////////////
//
//               Groundfire
//
////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2004, Tom Russell (tom@groundfire.net)
//
// This file is part of the Groundfire project, distributed under the MIT 
// license. See the file 'COPYING', included with this distribution, for a copy
// of the full MIT licence.
//
////////////////////////////////////////////////////////////////////////////////
//
//   File name : soundentity.hh
//
//          By : Tom Russell
//
//        Date : 22-Feb-04
//
// Description : Handles the sound entities
//
//
//
////////////////////////////////////////////////////////////////////////////////
#ifndef __SOUNDENTITY_HH__
#define __SOUNDENTITY_HH__

////////////////////////////////////////////////////////////////////////////////
// Includes
////////////////////////////////////////////////////////////////////////////////
#include "entity.hh"
#include "sounds.hh"

////////////////////////////////////////////////////////////////////////////////
// Exception Classes
////////////////////////////////////////////////////////////////////////////////

class cSoundEntity : public cEntity
{
public:
    cSoundEntity (cGame * game, int soundToPlay, bool looping);
    ~cSoundEntity ();

    void draw   (void);
    bool update (float time);

    void stop ();

private:
#ifndef NOSOUND
    cSound::cSoundSource _sound;
#endif
    bool                 _looping;
    bool                 _die;
};

#endif // __SOUNDENTITY_HH__
