////////////////////////////////////////////////////////////////////////////////
//
//               Groundfire
//
////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2004, Tom Russell (tom@groundfire.net)
//
// This file is part of the Groundfire project, distributed under the MIT 
// license. See the file 'COPYING', included with this distribution, for a copy
// of the full MIT licence.
//
////////////////////////////////////////////////////////////////////////////////
//
//   File name : soundentity.cc
//
//          By : Tom Russell
//
//        Date : 22-Feb-04
//
// Description : Handles the sound entities
//
//
//
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Includes
////////////////////////////////////////////////////////////////////////////////
#include "soundentity.hh"

////////////////////////////////////////////////////////////////////////////////
// Public Member Functions
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
//
// Function    : cSoundEntity
//
// Description : Constructor
//
////////////////////////////////////////////////////////////////////////////////
cSoundEntity::cSoundEntity
(
    cGame * game,
    int     soundToPlay, // Sound effect number
    bool    looping      // Will the sound loop continuously
)
        : cEntity (game), 
#ifndef NOSOUND
          _sound (game->getSound (), soundToPlay, looping),
#endif
          _looping (looping),
          _die (false)
{
}

////////////////////////////////////////////////////////////////////////////////
//
// Function    : ~cSoundEntity
//
// Description : Destructor
//
////////////////////////////////////////////////////////////////////////////////
cSoundEntity::~cSoundEntity
(
)
{
}

////////////////////////////////////////////////////////////////////////////////
//
// Function    : update
//
// Description : Update the sound entity
//
////////////////////////////////////////////////////////////////////////////////
bool
cSoundEntity::update
(
    float time
)
{
    // This isn't really used at the moment, a better way of stopping the 
    // sound is simply killing the entity.
    if (_die)
    {
        delete this;
        return (false);        
    }

    // If the sound is not a looping (continuous sound, we should check to see
    //if it has finished.) If it has we can destroy the sound entity
    if (!_looping)
    {
#ifndef NOSOUND
        if (!_sound.isSourcePlaying ())
#endif
        {
            delete this;
            return (false);
        }
    }

    return (true);
}

////////////////////////////////////////////////////////////////////////////////
//
// Function    : draw
//
// Description : Draws(?!) the sound entity
//
////////////////////////////////////////////////////////////////////////////////
void
cSoundEntity::draw
(
)
{
    // do nuttin' (natch)
}
